* File glmdl.inc - contains coefficients on nonlinear glass property models (modified) 


PARAMETERS

  AV(I)  Linear coefficients of viscosity model
   / SiO2    9.4700
     B2O3  -14.5915
     Na2O  -11.0184
     Li2O  -33.6984
     CaO    -5.3832
     MgO    -1.5024
     Fe2O3  -3.9269
     Al2O3  11.4124
     ZrO2    9.9016
     Other  -0.3041  /

  BV(I,J)  Cross term coefficients of viscosity model

  AE(I)  Linear coefficients of electrical conductivity model
   / SiO2    0.9121
     B2O3    6.0920
     Na2O   13.7875
     Li2O   100.4912
     CaO    -0.9357
     MgO    -0.9450
     Fe2O3   1.3811
     Al2O3  -0.7546
     ZrO2   -0.6340
     Other   2.1391  /

* AE(I) modified for Li

  BE(I,J)  Cross term coefficients of electrical conductivity model

  ADPB(I)  Linear coefficients of Durability (PCT) model (for Boron)
   / SiO2   -2.1186
     B2O3  -28.1878
     Na2O   15.6606
     Li2O   20.2263
     CaO    -8.4922
     MgO   -36.0019
     Fe2O3   2.0287
     Al2O3 -19.0994
     ZrO2   -4.1143
     Other   6.7180  /

  BDPB(I,J)  Cross term coefficients of Durability (PCT) model for Boron

  ADMB(I)  Linear coefficients of Durability (MCC) model (for Boron)
   / SiO2    3.4256
     B2O3   -5.5002
     Na2O   26.0694
     Li2O    6.4803
     CaO     5.4435
     MgO     4.5177
     Fe2O3   3.0065
     Al2O3  -8.8350
     ZrO2   -2.3333
     Other  -0.5088  /

  BDMB(I,J)  Cross term coefficients of Durability (MCC) model (for Boron);

* Specify NONZERO cross-term coefficients for glass property models =====

BV('B2O3','Fe2O3') =  36.5869;
BV('Fe2O3','Al2O3')=  34.8765;
BV('Al2O3','ZrO2') = -97.3354;
BV('B2O3','B2O3')  =  29.4816;

BE('SiO2','Li2O')  = -50.3716;
BE('Na2O','Li2O')  =-101.2283;
BE('B2O3','B2O3')  = -23.4896;

BDPB('B2O3','B2O3')   =  166.5814;
BDPB('SiO2','MgO')    =   93.5007;

BDMB('B2O3','B2O3')   =   55.6853;
BDMB('SiO2','Na2O')   =  -38.8016;

